<?php

namespace GSPIN\ShortcodeBuilder;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class Options {
    /**
     * Returns option based on the option key.
     * 
     * @since  2.0.12
     * 
     * @param string $option  The option key.
     * @param string $default The default value incase doesn't get the actual value.
     * 
     * @return mixed option value.
     */
    public function get( $option, $default = '' ) {
        $options = get_option( 'gspin_shortcode_prefs' );
        
        if ( isset( $options[ $option ] ) ) {
            return $options[ $option ];
        }
        
        return $default;
    }

    /**
     * Returns themes options.
     * 
     * @since  2.0.12
     * @return array Themes options.
     */
    public function getThemes() {
        $freeThemes = array(
            array(
                'label' => __( 'Theme 1 (Pins)', 'gs-pinterest' ),
                'value' => 'gs_pin_theme1'
            )
        );

        $proThemes = array(
            array(
                'label' => __( 'Theme 2 (Pin Links - PRO)', 'gs-pinterest' ),
                'value' => 'gs_pin_theme2' 
            ),
            array(
                'label' => __( 'Theme 3 (Hover - PRO)', 'gs-pinterest' ),
                'value' => 'gs_pin_theme3'
            ),
            array(
                'label' => __( 'Theme 4 (Popup - PRO)', 'gs-pinterest' ),
                'value' => 'gs_pin_theme4'
            ),
            array(
                'label' => __( 'Theme 5 (Greyscale - PRO)', 'gs-pinterest' ),
                'value' => 'gs_pin_theme5'
            )
        );

        if ( ! gspin()->helpers->isProActive() ) {
            $proThemes = array_map( function( $item ) {
                $item['pro'] = true;
                return $item;
            }, $proThemes );
        }

        return array_merge( $freeThemes, $proThemes );
    }

    /**
     * Returns link types options.
     * 
     * @since  2.0.12
     * @return array Link type options.
     */
    public function getLinkTypes() {
        return array(
            array(
                'value' => '_blank',
                'label' => __( 'New Tab', 'gs-pinterest' )
            ),
            array(
                'value' => '_self',
                'label' => __( 'Same Window', 'gs-pinterest' )
            )
        );
    }

    /**
     * Retrives WP registered possible thumbnail sizes.
     * 
     * @since  1.10.14
     * @return array   image sizes.
     */
    public function getPossibleThumbnailSizes() {
        $sizes = get_intermediate_image_sizes();

        if ( empty($sizes) ) {
            return [];
        }

        $result = [];
        foreach ( $sizes as $size ) {
            $result[] = [
                'label' => ucwords( preg_replace('/_|-/', ' ', $size) ),
                'value' => $size
            ];
        }
        
        return $result;
    }

    /**
     * Returns predefined columns
     * 
     * @since  2.0.12
     * @return array Predefined columns.
     */
    public function getColumns() {
        return array(
            array(
                'label' => __( '1 Column', 'gs-pinterest' ),
                'value' => '12'
            ),
            array(
                'label' => __( '2 Columns', 'gs-pinterest' ),
                'value' => '6'
            ),
            array(
                'label' => __( '3 Columns', 'gs-pinterest' ),
                'value' => '4'
            ),
            array(
                'label' => __( '4 Columns', 'gs-pinterest' ),
                'value' => '3'
            ),
            array(
                'label' => __( '5 Columns', 'gs-pinterest' ),
                'value' => '2_4'
            ),
            array(
                'label' => __( '6 Columns', 'gs-pinterest' ),
                'value' => '2'
            )
        );
    }


    /**
     * Returns default options.
     * 
     * @since  2.0.12
     * @return array Default options.
     */
    public function getDefaults() {

        return [
            'userid'                      => '',
            'themes'                      => gsPinBuilder()->options->getThemes(),
            'link_targets'                => gsPinBuilder()->options->getLinkTypes(),
            'gs_member_thumbnail_sizes'   => gsPinBuilder()->options->getPossibleThumbnailSizes(),
            
            // responsive
            'columns'                 => gsPinBuilder()->options->getColumns(),
            'columns_tablet'          => gsPinBuilder()->options->getColumns(),
            'columns_mobile_portrait' => gsPinBuilder()->options->getColumns(),
            'columns_mobile'          => gsPinBuilder()->options->getColumns(),
            'order' => array(
                array(
                    'label' => __( 'DESC', 'gs-pinterest' ),
                    'value' => 'DESC'
                ),
                array(
                    'label' => __( 'ASC', 'gs-pinterest' ),
                    'value' => 'ASC'
                )
            )
        ];
    }
}