<?php
namespace GSPIN\Addons;

// if direct access than exit the file.
defined('ABSPATH') || exit;

/**
 * Gutenberg block for pinterest pins.
 * 
 * @since 2.0.8
 */
class Block {

    public function __construct() {
        add_action( 'init', [ $this, 'load_block_script' ] );
        add_action( 'enqueue_block_editor_assets', [ $this, 'enqueue_block_editor_assets' ] );
    }

    public function load_block_script() {
        wp_add_inline_style( 'wp-block-editor', $this->get_block_css() );

        wp_register_script(
            'gs-pinterest-block',
            GSPIN_PLUGIN_URI . '/includes/Addons/Block/gs-pinterest/build/index.js',
            ['wp-blocks', 'wp-editor'], GSPIN_VERSION
        );

        $gs_pinterest_block = array(
            'title'                   => __( 'GS Pinterest Shortcode', 'gs-pinterest' ),
            'description'             => __( 'Show Pinterest Items by GS Pinterest Plugin', 'gs-pinterest' ),
            'select_shortcode'        => __( 'GS Pinterest Shortcode', 'gs-pinterest' ),
            'edit_description_text'   => __( 'Edit this shortcode', 'gs-pinterest' ),
            'edit_link_text'          => __( 'Edit', 'gs-pinterest' ),
            'create_description_text' => __( 'Create new shortcode', 'gs-pinterest' ),
            'create_link_text'        => __( 'Create', 'gs-pinterest' ),
            'edit_link'               => admin_url( "admin.php?page=gspin-shortcodes#/shortcode/" ),
            'create_link'             => admin_url( 'admin.php?page=gspin-shortcodes#/shortcode' ),
            'shorcodeList'            => gsPinBuilder()->manager->getShortcodesAsList()
		);

		wp_localize_script( 'gs-pinterest-block', 'GSPIN_BLOCK', $gs_pinterest_block );

        register_block_type( 'gs-pin/pinshortcodeblock', array(
            'editor_script' => 'gs-pinterest-block',
            'attributes' => [
                'shortcodeID' => [
                    'type'    => 'string',
                    'default' => gspin()->helpers->getDefaultOption()
                ]
            ],
            'render_callback' => [ $this, 'shortcodes_dynamic_render_callback' ]
        ) );

    }

    public function get_block_css() {

        ob_start(); ?>
    
        .gsbeh--toolbar {
            padding: 20px;
            border: 1px solid #1f1f1f;
            border-radius: 2px;
        }

        .gsbeh--toolbar label {
            display: block;
            margin-bottom: 6px;
            margin-top: -6px;
        }

        .gsbeh--toolbar select {
            width: 250px;
            max-width: 100% !important;
            line-height: 42px !important;
            padding: 7px;
        }

        .gsbeh--toolbar .gsbeh-block--des {
            margin: 10px 0 0;
            font-size: 16px;
        }

        .gsbeh--toolbar .gsbeh-block--des span {
            display: block;
        }

        .gsbeh--toolbar .gsbeh-block--des a {
            margin-left: 4px;
            display: inline-block;
        }
    
        <?php return ob_get_clean();
    
    }


    public function enqueue_block_editor_assets() {
        gspin()->assets->enqueueStyles();
        gspin()->assets->enqueueScripts();
    }

    public function shortcodes_dynamic_render_callback( $blockAttributes ) {
        $id = ! empty( $blockAttributes['shortcodeID'] ) ? absint( $blockAttributes['shortcodeID'] ) : gspin()->helpers->getDefaultOption();
        return do_shortcode( sprintf( '[gs_pinterest id="%d"]', $id ) );
    }

}
