<div class="row">
    <div class="panel panel-primary panel-default content-panel">
        <div class="panel-body">
        <table class="form-table2">
            <tr class="radio-span" style="border-bottom:none;">
                <td>
                <form id="gsp-recommended" class="layout-form">
                    <div id="poststuff">
                        <div id="post-body" class="metabox-holder">
                            <div id="postbox-container-2" class="postbox-container">
                                <div id="advanced" class="meta-box-sortables">
                                    <div id="gs_plugins_free" class="postbox" >
                                        <div class="handlediv" data-target="ux_recommendation" title="Click to toggle" data-toggle="collapse"><br></div>
                                        <h2 class="hndle"><?php _e( 'GS Plugins - recommended more free plugins', 'gs-pinterest' ); ?></h3>
                                        <div class="inside">
                                            <div id="gsp_recommendation" class="gsp-recommendation">
                                                
                                                <div class="fluid-layout">
                                                    <div class="layout-span12">
                                                        <div class="wp-list-table plugin-install">
                                                            <div id="the-list">
                                                                <?php
                                                                $items = gspin()->helpers->getFreePlugins();
                                                                foreach ( $items as $plugin )  {
                                                                    
                                                                    if ( is_object( $plugin ) ) {
                                                                        $plugin = (array) $plugin;
                                                                    }
                                                                    if ( ! empty( $plugin[ "icons" ][ "svg" ] ) ) {
                                                                        $plugin_icon_url = $plugin[ "icons" ][ "svg" ];
                                                                    } elseif ( ! empty( $plugin[ "icons" ][ "2x" ] ) ) {
                                                                        $plugin_icon_url = $plugin[ "icons" ][ "2x" ];
                                                                    } elseif ( ! empty ( $plugin[ "icons" ][ "1x" ] ) ) {
                                                                        $plugin_icon_url = $plugin[ "icons" ][ "1x" ];
                                                                    } else {
                                                                        $plugin_icon_url = $plugin[ "icons" ][ "default" ];
                                                                    }
                                                                
                                                                    $title          = wp_kses_post( $plugin['name'] );
                                                                    $description    = strip_tags( $plugin['short_description'] );
                                                                    $author         = wp_kses_post( $plugin['author'] );
                                                                    $version        = wp_kses_post( $plugin['version'] );
                                                                    $name           = strip_tags( $title . " " . $version );
                                                                    $details_link   = self_admin_url( "plugin-install.php?tab=plugin-information&amp;plugin={$plugin['slug']}&amp;TB_iframe=true&amp;width=600&amp;height=550" );
                                                                    
                                                                    /* translators: 1: Plugin name and version. */
                                                                    $action_links[] = '<a href="' . esc_url( $details_link ) . '" class="thickbox" aria-label="' . esc_attr( sprintf("More information about %s", $name ) ) . '" data-title="' . esc_attr( $name ) . '">' . __( 'More Details' ) . '</a>';
                                                                    $action_links = array();
                                                                    if ( current_user_can( 'install_plugins' ) || current_user_can( 'update_plugins' ) ) {
                                                                        $status = install_plugin_install_status( $plugin );
                                                                
                                                                        switch ( $status[ 'status' ] ) {
                                                                            case "install":
                                                                                if ( $status['url'] ) {
                                                                                    $action_links[] = sprintf( '<a class="install-now button" href="%s" aria-label="%s">%s</a>', esc_url( $status['url'] ),  esc_attr( sprintf( 'Install %s now', $name ) ), __( 'Install Now', 'gs-pinterest' ) );
                                                                                }
                                                                            break;
                                                                
                                                                            case "update_available":
                                                                                if ( $status[ 'url' ] ) {
                                                                                    $action_links[] = sprintf( '<a class="button" href="%s" aria-label="%s">%s</a>', esc_url( $status['url'] ), esc_attr( sprintf( "Update %s now", $name ) ), __( 'Update Now', 'gs-pinterest' ) );
                                                                                }
                                                                            break;
                                                                
                                                                            case "latest_installed":
                                                                                // can do something;
                                                                
                                                                            case "newer_installed":
                                                                                $action_links[] = sprintf( '<span class="button button-disabled" title="%s">%s</span>', esc_attr__( "This plugin is already installed and is up to date" ), _x( 'Installed', 'gs-pinterest' ) );
                                                                            break;
                                                                        }
                                                                    }
                                                                    ?>
                                                                    <div class="plugin-div plugin-div-settings">
                                                                        <div class="plugin-div-top plugin-div-settings-top">
                                                                            <div class="plugin-div-inner-content">
                                                                                <a href="<?php echo esc_url( $details_link ); ?>" class="thickbox plugin-icon plugin-icon-custom">
                                                                                    <img class="custom_icon" src="<?php echo esc_attr( $plugin_icon_url ) ?>" />
                                                                                </a>
                                                                                <div class="name column-name">
                                                                                    <h4>
                                                                                        <a href="<?php echo esc_url( $details_link ); ?>" class="thickbox"><?php echo $title; ?></a>
                                                                                    </h4>
                                                                                </div>
                                                                                <div class="desc column-description">
                                                                                    <p>
                                                                                        <?php echo $description; ?>
                                                                                    </p>
                                                                                    <p class="authors">
                                                                                        <cite> <?php _e( 'By', 'gs-pinterest' ); ?> <?php echo $author;?></cite>
                                                                                    </p>
                                                                                </div>
                                                                            </div>
                                                                            <div class="action-links">
                                                                                <ul class="plugin-action-buttons-custom">
                                                                                    <li>
                                                                                        <?php
                                                                                            if ( $action_links ) {
                                                                                                echo implode( '</li><li>', $action_links );
                                                                                            }
                                                                                        ?>
                                                                                    </li>
                                                                                </ul>
                                                                            </div>
                                                                        </div>
                                                                        <div class="plugin-card-bottom plugin-card-bottom_settings">
                                                                            <div class="vers column-rating">
                                                                                <?php
                                                                                    gspin()->helpers->wp_star_rating(array(
                                                                                        'rating' => $plugin['rating'],
                                                                                        'type'   => 'percent',
                                                                                        'number' => $plugin['num_ratings']
                                                                                    ));
                                                                                ?>
                                                                                <span class="num-ratings">(<?php echo number_format_i18n( $plugin['num_ratings'] ); ?>)</span>
                                                                            </div>
                                                                            <div class="column-updated">
                                                                                <strong><?php _e( 'Last Updated:', 'gs-pinterest' ); ?></strong> <span title="<?php echo esc_attr( $plugin['last_updated' ] ); ?>">
                                                                                    <?php printf( "%s ago", human_time_diff( strtotime( $plugin['last_updated'] ) ) ); ?>
                                                                                </span>
                                                                            </div>
                                                                            <div class="column-downloaded">
                                                                            <?php echo sprintf( _n("%s download", "%s downloads", $plugin["downloaded"]), number_format_i18n($plugin["downloaded"])); ?>
                                                                            </div>
                                                                            <div class="column-compatibility">
                                                                                <?php
                                                                                    if ( ! empty( $plugin[ 'tested' ] ) && version_compare( substr( $GLOBALS["wp_version"], 0, strlen( $plugin['tested'] ) ), $plugin['tested'], ">")) {
                                                                                        echo '<span class="compatibility-untested">' . __( '<strong>Untested</strong> with your version of WordPress', 'gs-pinterest' ) . '</span>';
                                                                                    } 
                                                                                    elseif ( ! empty( $plugin[ 'requires' ] ) && version_compare( substr( $GLOBALS[ 'wp_version' ], 0, strlen( $plugin[ 'requires' ] ) ), $plugin['requires'], "<" ) ) {
                                                                                        echo '<span class="compatibility-incompatible">' . __( 'Incompatible with your version of WordPress', 'gs-pinterest' ) . '</span>';
                                                                                    } else {
                                                                                        echo '<span class="compatibility-compatible">' . __( 'Compatible with your version of WordPress', 'gs-pinterest' ) . '</span>';
                                                                                    }
                                                                                ?>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                <?php } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
                </td>
            </tr>
        </table>
        </div>
    </div>
</div> <!-- /row -->