<?php

namespace GSPIN\ShortcodeBuilder;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class Preferences {

    public $ajax = false;

    /**
     * Constructor of the class.
     * 
     * @since 2.0.12
     */
    public function __construct() {
        add_action( 'wp_ajax_gspin_get_shortcode_pref', array($this, 'getPreferences') );
        add_action( 'wp_ajax_gspin_save_shortcode_pref', array($this, 'savePreferences') );
    }

    /**
     * Ajax endpoint for retriving shortcode preferences.
     * 
     * @since 2.0.12
     */
    public function getPreferences() {
        gsPinBuilder()->preferences->ajax = true;
        return gsPinBuilder()->preferences->get();
    }

    /**
     * Ajax endpoint for saving shortcode preferences.
     * 
     * @since 2.0.12
     */
    public function savePreferences( $nonce = null ) {
        if ( ! $nonce ) {
            $nonce = wp_create_nonce('_gspin_save_shortcode_pref_gs_');
        }

        if ( empty($_POST['prefs']) ) {
            wp_send_json_error( __( 'No preference provided', 'gs-pinterest' ), 400 );
        }

        $this->save( $nonce, $_POST['prefs'], true );
    }

    /**
     * Get shortcode preferences options.
     * 
     * @since  2.0.12
     * @return array
     */
    public function getShortcodePreferenceOptions() {
        return [];
    }

    /**
     * Get default shortcode preferences.
     * 
     * @since  2.0.12
     * @return array
     */
    public function getDefaults() {
        return array(
            'gspin_custom_css' => ''
        );
    }

    /**
     * Helper method for saving shortcode preferences.
     * 
     * @since  2.0.12
     * @return wp_json response.
     */
    public function save( $nonce, $settings, $is_ajax ) {
        if ( ! wp_verify_nonce( $nonce, '_gspin_save_shortcode_pref_gs_') ) {
            if ( $is_ajax ) wp_send_json_error( __( 'Unauthorised Request', 'gs-pinterest' ), 401 );
            return false;
        }

        // Maybe add validation?
        update_option( 'gspin_shortcode_prefs', $settings, 'yes' );

        if ( $is_ajax ) {
            wp_send_json_success( __( 'Preference saved', 'gs-pinterest' ) );
        }
    }

    /**
     * Get shortcode preferences.
     * 
     * @since 2.0.12
     * 
     * @param  bool         $is_ajax If want the reponse as ajax response.
     * @return wp_json|array 
     */
    public function get( $key = '', $default = '' ) {
        $pref = get_option( 'gspin_shortcode_prefs' );

        if ( empty( $pref ) ) {
            $pref = gsPinBuilder()->preferences->getDefaults();
            $this->save( wp_create_nonce('_gspin_save_shortcode_pref_gs_'), $pref, false );
        }

        if ( gsPinBuilder()->preferences->ajax ) {
            wp_send_json_success( $pref );
        }

        if ( ! gsPinBuilder()->preferences->ajax && ! empty( $key ) ) {
            return ! empty( $pref[ $key ] ) ? $pref[ $key ] : $default;
        }

        return $pref;
    }

}