require('./includes/polyfills.js');

import Vue from 'vue';
import VueRouter from 'vue-router';
import helpers from './includes/helpers';
import Clipboard from 'clipboard';
import VueConfirmDialog from 'vue-confirm-dialog';

window.Clipboard = Clipboard;

// Pages
import Shortcodes from './pages/shortcodes.vue';
import Shortcode from './pages/shortcode.vue';
import Preferences from './pages/preferences.vue';

// global use
Vue.use(VueRouter);
Vue.use(VueConfirmDialog);

window.Events = new Vue({});

Vue.mixin({
	methods: helpers
});

Vue.component( 'input-tag', 		require('./components/input-tag.vue').default );
Vue.component( 'input-increment', 	require('./components/input-increment.vue') .default );
Vue.component( 'input-range', 		require('./components/input-range.vue').default );
Vue.component( 'input-checkbox', 	require('./components/input-checkbox.vue').default );
Vue.component( 'input-radio', 		require('./components/input-radio.vue').default );
Vue.component( 'input-select', 		require('./components/input-select/component/select.vue').default );
Vue.component( 'input-color', 		require('./components/input-color/input-color.vue').default );
Vue.component( 'input-toggle', 		require('./components/input-toggle.vue').default );
Vue.component( 'editor-cm', 		require('./components/editor-codemirror/component/editor-cm.vue').default );
Vue.component( 'vue-confirm-dialog', VueConfirmDialog.default );

jQuery(function($){

	const routes = [
		{ path : '/',              component: Shortcodes },
		{ path : '/shortcode',     component: Shortcode },
		{ path : '/shortcode/:id', component: Shortcode },
		{ path : '/preferences',   component: Preferences }
	];

	const router = new VueRouter({ routes });

	if ( $('#gspin-shortcode-app').length > 0 ) {
		window.app = new Vue({
			router
		}).$mount('#gspin-shortcode-app');
	}

	let $team_admin_menu;

	function fixAdminActiveLink( currentPath ) {

		if ( !$team_admin_menu || !$team_admin_menu.length ) $team_admin_menu = $('#menu-posts-gs_team');
		if ( !$team_admin_menu.length ) {
			return;
		}

		let $shortcode_link = $team_admin_menu.find( "a[href='edit.php?post_type=gs_team&page=gspin-shortcodes']" );
			$shortcode_link.parent().addClass('current').siblings('li').removeClass('current');

	}

	router.beforeEach((to, from, next) => {

		fixAdminActiveLink( to.path );
		next();

	});

	fixAdminActiveLink( router.history.current.path );

});