<?php 
/**
 *
 * @package   GS_Pinterest_Portfolio
 * @author    GS Plugins <hello@gsplugins.com>
 * @license   GPL-2.0+
 * @link      https://www.gsplugins.com
 * @copyright 2016 GS Plugins
 *
 * @wordpress-plugin
 * Plugin Name:			GS Pins for Pinterest Lite
 * Plugin URI:			https://www.gsplugins.com/wordpress-plugins
 * Description:       	Best Responsive Pinterest plugin for Wordpress to showcase Pinterest Pins. Display anywhere at your site using shortcode like [gs_pinterest] & widgets. Check more shortcode examples and documentation at <a href="https://pinterest.gsplugins.com">GS Pinterest Porfolio PRO Demos</a> | <a href="https://docs.gsplugins.com/gs-pinterest-portfolio">Docs</a>
 * Version:           	1.4.3
 * Author:       		GS Plugins
 * Author URI:       	https://www.gsplugins.com
 * Text Domain:       	gs-pinterest
 * License:           	GPL-2.0+
 * License URI:       	http://www.gnu.org/licenses/gpl-2.0.txt
*/

// if direct access than exit the file.
defined('ABSPATH') || exit;

/**
 * Defining constants
 */
define( 'GSPIN_VERSION', '1.4.3' );
define( 'GSPIN_MENU_POSITION', 31 );
define( 'GSPIN_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
define( 'GSPIN_PLUGIN_URI', plugins_url( '', __FILE__ ) );
define( 'GSPIN_PLUGIN_BASENAME', plugin_basename( __FILE__ ) );

/**
 * Initiate Autoloader for Class Load
 * 
 * @since 2.0.8
 */
if ( ! class_exists( 'GSPIN\Autoloader' ) ) {
    require GSPIN_PLUGIN_DIR . 'includes/autoloader.php';
    GSPIN\Autoloader::init();
}

/**
 * Activation redirects
 *
 * @since v1.0.0
 */
register_activation_hook(__FILE__, function() {
	gspin()->db->migration();
    add_option('gspin_activation_redirect', true);
});



/**
 * Remove Reviews Metadata on plugin Deactivation.
 */
register_deactivation_hook(__FILE__, function() {
    delete_option('gspin_active_time');
    delete_option('gspin_maybe_later');
    delete_option('gsadmin_maybe_later');
});

if ( ! function_exists( 'gspin' ) ) {
	/**
	 * This function is responsible for running the main plugin.
	 * 
	 * @since  2.0.8
	 * @return object GSPIN The plugin instance.
	 */
	function gspin() {
		return GSPIN\GSPIN::getInstance();
	}
    gspin();
}

if ( 'gsPinBuilder' ) {
	/**
	 * This function is responsible for running the shortcode builder.
	 * 
	 * @since  2.0.12
	 * @return object GSPIN\ShortcodeBuilder\Builder The plugin instance.
	 */
	function gsPinBuilder() {
        return GSPIN\ShortcodeBuilder\Builder::get_instance();
    }
	gsPinBuilder();
}

