<?php
namespace GSPIN\Addons;

// if direct access than exit the file.
defined('ABSPATH') || exit;

use \Elementor\Widget_Base;
use \Elementor\Plugin;

class Addons {

    /**
     * Instance of WPBackery widget
     * 
     * @since 2.0.12
     * @var   GSBEH\Addons\WPBackery
     */
    public $wpBackery;

    /**
     * Instance of Elementor widget
     * 
     * @since 2.0.12
     * @var   GSBEH\Addons\Elementor
     */
    public $elementor;

    // Constructor of the class.
    public function __construct() {
        //register elementor widget.
        if ( $this->isElementorActive() ) {
            add_action( 'elementor/widgets/widgets_registered', function() {
                $this->elementor = Plugin::instance()->widgets_manager->register_widget_type( new Elementor() );
            });
        }

        //loads wpbackery widget.
        add_action( 'plugins_loaded', function() {
            if ( $this->isWPBackeryActive() ) {
                $this->wpBackery = new WPBackery;
            }
        });
        // $this->block = new Block;
    }

    /**
     * We check if the Elementor plugin has been installed / activated.
     * 
     * @since  2.0.12
     * @return boolean
     */
	public function isElementorActive() {
		return defined( 'ELEMENTOR_PATH' );
	}

    /**
     * We check if the WPBackery plugin has been installed / activated.
     * 
     * @since  2.0.12
     * @return boolean
     */
    public function isWPBackeryActive() {
        return defined( 'WPB_VC_VERSION' );
    }

    /**
     * We check if the Divi plugin has been installed / activated.
     * 
     * @since  2.0.12
     * @return boolean
     */
    public function isDiviActive() {
        return defined( 'ET_BUILDER_PLUGIN_DIR' );
    }
}