<?php

namespace GSPIN;

// if direct access than exit the file.
defined('ABSPATH') || exit;

class Admin {
    
    /**
     * Singleton Instance
     *
     * @access private static
     */
    private static $instance;
    
    /**
     * Class Constructor
     *
     * @since  2.0.8
     * @return void
     */
    public function __construct() {
        $this->settings_api = new \GSPIN\Settings\SettingsApi;
        
        add_action( 'admin_menu', array( $this, 'menus' ) );
        add_action( 'admin_init', array($this, 'admin_init') );
    }
    
    /**
     * Get class singleton instance
     *
     * @return Class Instance
     */
    public static function get_instance() {
        if ( ! self::$instance instanceof GSPlugins_wps ) {
            self::$instance = new GSPlugins_wps();
        }
        
        return self::$instance;
    }
    
    /**
     * Registers dashboard menus.
     * 
     * @since 
     */
    public function menus() {
        add_menu_page(
            __( 'GS Pinterest', 'gs-pinterest' ),
            __( 'GS Pinterest', 'gs-pinterest' ),
            'manage_options',
            'gsp-pinterest-main',
            array( $this, 'view' ),
            GSPIN_PLUGIN_URI . '/assets/img/menu-icon.png',
            GSPIN_MENU_POSITION
        );

        add_submenu_page(
            'gsp-pinterest-main',
            __( 'Pinterest Settings', 'gs-pinterest' ),
            __( 'Settings', 'gs-pinterest' ),
            'delete_posts',
            'pinterest-settings',
            array( $this, 'plugin_page' )
        );

        add_submenu_page( 
            'gsp-pinterest-main',
            __( 'GS Plugins', 'gs-pinterest' ),
            __( 'Pro Plugins', 'gs-pinterest' ),
            'manage_options',
            'gspin-shortcodes',
            array( $this, 'displayMainMenuPage' )
        );

        add_submenu_page(
            'gsp-pinterest-main',
            __( 'GS Plugins', 'pinterest' ),
            __( 'Free Plugins', 'pinterest' ),
            'manage_options', 
            'gs-plugins-free', 
            array( $this, 'displayFreeItems' )
        );

        add_submenu_page( 
            'gsp-pinterest-main',
            __( 'Help', 'gs-pinterest' ),
            __( 'Help', 'gs-pinterest' ),
            'manage_options', 
            'gs-pin-help', 
            array( $this, 'displayHelpPage' )
        );
    }

    /**
     * Includes view of shortcode builder.
     * 
     * @since  2.0.12
     * @return void
     */
    public function view() {
        include GSPIN_PLUGIN_DIR . 'ShortcodeBuilder/Page.php';
    }

    /**
     * Display's main menu page.
     * 
     * @since 2.0.8
     */
    public function displayMainMenuPage() {
        $protocol = is_ssl() ? 'https' : 'http';
        $response = wp_remote_get( $protocol . '://gsplugins.com/gs_plugins_list/index.php' );

        if ( ! is_wp_error ( $response ) ) {
            echo $response['body'];
        }
    }

    /**
     * Display help page.
     * 
     * @since 2.0.8
     */
    public function displayHelpPage() {
        include GSPIN_PLUGIN_DIR . 'includes/views/Help.php';
    }

    /**
	 * Callback method for displaying free items page.
	 * 
	 * @since 2.0.8
	 */
    public function displayFreeItems() {
        include GSPIN_PLUGIN_DIR . 'includes/views/FreeItems.php';
    }

    public function admin_init() {
        //set the settings
        $this->settings_api->set_sections( gspin()->settingsConfig->get_settings_sections() );
        $this->settings_api->set_fields( gspin()->settingsConfig->get_settings_fields() );

        //initialize settings
        $this->settings_api->admin_init();
    }

    public function plugin_page() {
        include GSPIN_PLUGIN_DIR . 'includes/views/PluginPage.php';
    }
}
