<?php

namespace GSPIN;

// if direct access than exit the file.
defined('ABSPATH') || exit;

/**
 * Handle plugin assets.
 * 
 * @since 2.0.8
 */
class Assets {

    /**
     * Constructor of the class.
     * 
     * @since 2.0.8
     */
    public function __construct() {
        add_action( 'admin_enqueue_scripts', array( $this, 'adminScripts' ) );
        add_filter( 'gspin_custom_style', array( $this, 'renderCustomStyles' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueueScripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueueStyles' ) );
        add_action( 'elementor/editor/after_enqueue_styles', array( $this, 'elmentorEditorStyle' ) );
    }

    /**
     * Enqueue admin scripts.
     * 
     * @since 2.0.8
     */
    public function adminScripts() {
        $screen = \get_current_screen();

        wp_register_style(
			'gspin-free-plugins-style',
			GSPIN_PLUGIN_URI . '/settings/css/gs_free_plugins.css',
			'',
			GSPIN_VERSION,
			'all'
		);
        wp_enqueue_style( 'gspin-free-plugins-style' );

        wp_register_script(
            'gspin-admin-js',
            GSPIN_PLUGIN_URI . '/settings/js/gs_pin_admin_script.js',
            array( 'jquery' ),
            GSPIN_VERSION,
            true
        );

        wp_register_style(
            'gspin-admin-style',
            GSPIN_PLUGIN_URI . '/settings/css/gspin_admin_style.css',
            '',
            GSPIN_VERSION,
            'all'
        );

        wp_register_style(
            'gspin-free-plugin-style',
            GSPIN_PLUGIN_URI . '/settings/css/gs_free_plugins.css',
            '',
            GSPIN_VERSION,
            'all'
        );

        wp_register_style(
			'gs-pin-custom-bootstrap',
			GSPIN_PLUGIN_URI . '/assets/css/gs-pin-custom-bootstrap.css',
			'', GSPIN_VERSION, 'all'
		);

        if ( $screen->is_block_editor() && ( 'post' === $screen->id || 'page' === $screen->id ) ) {
            wp_enqueue_script('gspin-admin-js');
        }

        wp_enqueue_style( 'gs-pin-custom-bootstrap' );
        wp_enqueue_style( 'gspin-admin-style' );
        wp_enqueue_style( 'gspin-free-plugin-style' );
    }

    /**
     * Enqueue plugin scripts.
     * 
     * @since 2.0.8
     */
    public function enqueueScripts() {
        wp_enqueue_script('masonry');

        wp_register_script(
            'gspin-img-loaded-js',
            GSPIN_PLUGIN_URI . '/assets/js/imagesloaded.pkgd.min.js',
            array('jquery'),
            GSPIN_VERSION,
            true
        );
        wp_enqueue_script('gspin-img-loaded-js');

        wp_register_script(
            'pinterest-pinit-js',
            '//assets.pinterest.com/js/pinit.js',
            array(),
            GSPIN_VERSION,
            true
        );
        wp_register_script(
            'gspin-custom',
            GSPIN_PLUGIN_URI . '/assets/js/gspin.custom.js',
            array('jquery'),
            GSPIN_VERSION,
            true
        );
        
        
        wp_enqueue_script('pinterest-pinit-js');
        wp_enqueue_script('gspin-custom');
	}

    /**
     * Enqueue plugin styles.
     * 
     * @since 2.0.8
     */
    public function enqueueStyles() {
        wp_register_style(
            'gspin-fa-icons',
            GSPIN_PLUGIN_URI . '/assets/fa-icons/css/font-awesome.min.css',
            '',
            GSPIN_VERSION,
            'all'
        );

        wp_register_style(
            'gs_pin_custom_css',
            GSPIN_PLUGIN_URI . '/assets/css/gs-pin-custom.css',
            '',
            GSPIN_VERSION,
            'all'
        );

        wp_register_style(
			'gs-pin-custom-bootstrap',
			GSPIN_PLUGIN_URI . '/assets/css/gs-pin-custom-bootstrap.css',
			'', GSPIN_VERSION, 'all'
		);

        // Binding the custom css to the mail style.
        $cssFromPreferences = gsPinBuilder()->preferences->get( 'gspin_custom_css' );
		$customStyles       = apply_filters( 'gspin_custom_style', $cssFromPreferences );

		wp_add_inline_style( 'gs_pin_custom_css', $customStyles );

        wp_enqueue_style( 'gs-pin-custom-bootstrap' );
        wp_enqueue_style('gspin-fa-icons');
        wp_enqueue_style('gspin-mfp-css');
        wp_enqueue_style('gs_pin_custom_css');
	}

    /**
	 * Rendering the custom css.
	 * 
	 * @since  2.0.8
	 * @return void
	 */
    public function renderCustomStyles( $css ) {
		$css .= gspin()->helpers->getOption( 'gs_pin_custom_css', '' );
		return $css;
	}

    /**
	 * Print styles for the elementor editor.
	 */
	public function elmentorEditorStyle() {
		$icon = GSPIN_PLUGIN_URI . '/assets/img/icon-128x128.png';
		?>
		<style>
			body #elementor-panel-elements-wrapper .icon .gs-pinterest-plugin-icon {
				background: url('<?php echo $icon; ?>') no-repeat center center;
				background-size: contain;
				height: 29px;
				display: block;
			}
		</style>
		<?php
	}

}