<?php

namespace GSPIN;

// if direct access than exit the file.
defined('ABSPATH') || exit;

final class GSPIN {

    /**
     * Holds the instance of the plugin currently in use.
     *
     * @since 2.0.8
     *
     * @var GSPIN\GSPIN
     */
    private static $instance = null;

    /**
     * Main Plugin Instance.
     *
     * Insures that only one instance of the addon exists in memory at any one
     * time. Also prevents needing to define globals all over the place.
     *
     * @since  2.0.8
     * @return GSPIN
     */
	public static function getInstance() {
		if ( ! self::$instance ) {
			self::$instance = new self();
		}

		return self::$instance;
	}

    /**
     * Instance of the admin class.
     * 
     * @since 2.0.8
     * @var   GSPIN\Admin 
     */
    public $assets;

    /**
     * Instance of the admin class.
     * 
     * @since 2.0.8
     * @var   GSPIN\Admin 
     */
    private $admin;

    /**
     * Instance of the shortcode class.
     *
     * @since 2.0.8
     * @var   GSPIN\Shortcode 
     */
    public $shortcodes;
    
    /**
     * Instance of the database class.
     *
     * @since 2.0.8
     * @var   GSPIN\Database
     */
    public $db;

    /**
     * Holds the settings api config
     * 
     * @since 2.0.8
     * @var   GSPIN\Settings\SettingsConfig 
     */
    public $settingsConfig;

    /**
     * Holds the settings fields
     * 
     * @since 2.0.8
     * @var   GSPIN\Settings\SettingsApi
     */
    public $scriptsFields;

    /**
     * Instance of the Helpers class.
     *
     * @since 2.0.8
     * @var   GSPIN\Helpers
     */
    public $helpers;


    /**
     * Class Constructor
     *
     * @since  2.0.8
     * @return void
     */
    public function __construct() {
        $this->preLoad();
        $this->appsero_init_tracker_gs_pinterest_portfolio();

        $this->assets         = new \GSPIN\Assets;
        $this->admin          = new \GSPIN\Admin;
        $this->helpers        = new \GSPIN\Helpers;
        $this->settingsApi    = new \GSPIN\Settings\SettingsApi;
        $this->settingsConfig = new \GSPIN\Settings\SettingsConfig;
        $this->block          = new \GSPIN\Addons\Block;
        $this->shortcodes     = new \GSPIN\Shortcodes;
        $this->notices        = new \GSPIN\Notices;
        $this->widgets        = new \GSPIN\Widgets;
        $this->addons         = new \GSPIN\Addons\Addons;
        $this->migration      = new \GSPIN\Migration;

        add_action( 'admin_init', array( $this, 'activationRedirect' ) );
        if ( ! $this->helpers->isProActive() ) {
            add_filter( 'plugin_action_links_' . GSPIN_PLUGIN_BASENAME, array( $this, 'gs_pinterest_pro_link' ) );
        }
    }

    /**
     * Assining the database class.
     *
     * @since  2.0.8
     * @return GSPIN\Database
     */
    public function preLoad() {
        $this->db = new \GSPIN\Database;
    }

    /**
     * Populate plugins pro package link.
     * 
     * @since 2.0.8
     */
    public function gs_pinterest_pro_link( $gsPin_links ) {
        $gsPin_links[] = '<a class="gs-pro-link" href="https://www.gsplugins.com/product/gs-pinterest-portfolio" target="_blank">Go Pro!</a>';
        $gsPin_links[] = '<a href="https://www.gsplugins.com/wordpress-plugins" target="_blank">GS Plugins</a>';
        return $gsPin_links;
    }

    /**
     * Redirect to options page
     *
     * @since v1.0.0
     */
    public function activationRedirect() {
        if (get_option('gspin_activation_redirect', false)) {
            delete_option('gspin_activation_redirect');
            if(!isset($_GET['activate-multi']))
            {
                wp_redirect("admin.php?page=gs-pin-help");
            }
        }
    }

    /**
     * Initialize the plugin tracker
     *
     * @return void
     */
    function appsero_init_tracker_gs_pinterest_portfolio() {
        if ( ! class_exists( 'AppSero\Insights' ) ) {
            require_once GSPIN_PLUGIN_DIR . '/appsero/src/Client.php';
        }

        $client = new \Appsero\Client( '2bf3f746-49ec-410b-91e2-b0362b5f669a', 'GS Pinterest Portfolio', __FILE__ );

        // Active insights
        $client->insights()->init();
    }

    /**
     * Get plugin license status
     * 
     * @since  2.0.12
     * @return string The plugin lincense status valid or invalid.
     */
    public function getLicenseStatus() {
        return get_option( 'GS_PINTEREST_LICENSE_STATUS', 'invalid' );
    }
}